﻿using System;
using System.Drawing;
using System.Runtime.InteropServices;
using System.Windows.Forms;

namespace PWS.API.Mouse.Sample2
{
    public partial class FormMain : Form
    {
        private Point prevPtrLoc, // Previous Pointer Location : (X,Y)
                     curntPtrLoc; // Current Pointer Location : (X,Y)

        [DllImport("user32.dll")]
        public static extern bool GetCursorPos(out Point lpPoint);

        [DllImport("user32.dll")]
        public static extern bool SetCursorPos(int x, int y);

        public FormMain()
        {
            InitializeComponent();
        }

        private void ButtonStart_Click(object sender, EventArgs e)
        {
            timerMouse.Enabled = true;
            labelInfo.Visible = true;
            pictureBoxActive.Visible = false;
            labelMessage.Text = @"Click on Stop button to return to normal mouse motion:";
            buttonStart.Enabled = false;
            buttonStop.Enabled = true;
            buttonStop.Focus();

            GetCursorPos(out prevPtrLoc);
        }

        private void ButtonStop_Click(object sender, EventArgs e)
        {
            timerMouse.Enabled = false;
            pictureBoxActive.Visible = true;
            labelMessage.Text = @"Click on Start button to reverse mouse motion:";
            labelInfo.Text = "";
            buttonStop.Enabled = false;
            buttonStart.Enabled = true;
            buttonStart.Focus();
        }

        private void TimerMouse_Tick(object sender, EventArgs e)
        {
            GetCursorPos(out curntPtrLoc);
            int offsetX = curntPtrLoc.X - prevPtrLoc.X;
            int offsetY = curntPtrLoc.Y - prevPtrLoc.Y;
            int screenwidth = Screen.PrimaryScreen.Bounds.Width - 2;
            int screenHeight = Screen.PrimaryScreen.Bounds.Height - 2;
            curntPtrLoc.X = curntPtrLoc.X - (offsetX * 2);
            curntPtrLoc.Y = curntPtrLoc.Y - (offsetY * 2);
            if (curntPtrLoc.X <= 0) curntPtrLoc.X = 2;
            if (curntPtrLoc.Y <= 0) curntPtrLoc.Y = 2;
            if (curntPtrLoc.X >= screenwidth) curntPtrLoc.X = screenwidth;
            if (curntPtrLoc.Y >= screenHeight) curntPtrLoc.Y = screenHeight;
            SetCursorPos(curntPtrLoc.X, curntPtrLoc.Y);
            labelInfo.Text = @"x: " + curntPtrLoc.X + @"y: " + curntPtrLoc.Y;
            prevPtrLoc = curntPtrLoc;
        }
    }
}